/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.js.debug.core.model.IJSVariable;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.osgi.service.prefs.BackingStoreException;

public class ShowConstantsActionDelegate
extends ViewerFilter
implements IViewActionDelegate,
IActionDelegate2 {
    private IViewPart fView;
    private IAction fAction;

    public void init(IViewPart view) {
        this.fView = view;
        StructuredViewer viewer = this.getStructuredViewer();
        ViewerFilter[] filters = viewer.getFilters();
        ViewerFilter filter = null;
        ViewerFilter[] viewerFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter f = viewerFilterArray[n2];
            if (((Object)((Object)this)).equals(f)) {
                filter = f;
                break;
            }
            ++n2;
        }
        if (filter == null) {
            viewer.addFilter((ViewerFilter)this);
        }
        viewer.refresh();
        this.fAction.setChecked(this.getPreferenceValue(view));
    }

    public void dispose() {
    }

    public void init(IAction action) {
        this.fAction = action;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        IEclipsePreferences preferences = this.getPreferences();
        String key = String.valueOf(this.fView.getSite().getId()) + "." + this.getPreferenceKey();
        preferences.putBoolean(key, action.isChecked());
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
        }
        this.getStructuredViewer().refresh();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IJSVariable) {
            try {
                if (!this.getValue()) {
                    return !((IJSVariable)element).isConst();
                }
            }
            catch (DebugException e) {
                IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (Throwable)e);
            }
        }
        return true;
    }

    protected IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode("com.aptana.js.debug.ui");
    }

    protected boolean getPreferenceValue(IViewPart part) {
        String baseKey = this.getPreferenceKey();
        String viewKey = part.getSite().getId();
        String compositeKey = String.valueOf(viewKey) + "." + baseKey;
        IEclipsePreferences preferences = this.getPreferences();
        return preferences.getBoolean(compositeKey, preferences.getBoolean(baseKey, false));
    }

    protected StructuredViewer getStructuredViewer() {
        Viewer viewer;
        IDebugView view = (IDebugView)this.fView.getAdapter(IDebugView.class);
        if (view != null && (viewer = view.getViewer()) instanceof StructuredViewer) {
            return (StructuredViewer)viewer;
        }
        return null;
    }

    protected boolean getValue() {
        return this.fAction.isChecked();
    }

    protected String getPreferenceKey() {
        return "com.aptana.js.debug.ui.show_constants";
    }
}

